#!/bin/sh
#------------------------------------------------------------------------------
# PFTPD main form
#
# Creation:    2001-06-19  Florian Zierer
# Last update: 2006-01-01  Arno Welzel
#------------------------------------------------------------------------------

. /srv/www/include/cgi-helper
. /var/run/pftpd.conf

check_rights "pftpd" "action"

# hack for proper tab-selection, inspired by pf.cgi
: ${FORM_action:=opt_control}
: ${FORM_log_lines:=50}
: ${FORM_log_sort:=reverse}
: ${FORM_showall:=}
myname=`basename $0`

show_html_header "PureFTP"

show_tab_header "$_opt_control" "$myname?action=opt_control" \
				"$_opt_user" "$myname?action=opt_user" \
				"$_opt_connections" "$myname?action=opt_connections" \
				"$_opt_logfile" "$myname?action=opt_logfile"

case $FORM_action in
opt_control)
	if [ "$FORM_command" = "" ]
	then
		if [ -f /var/run/pure-ftpd.pid ]
		then
		  echo "<table class=\"normtable\"><tr><td bgcolor=\"#80ff80\">$_ctr_statusrun</td><td> <a href=\"$myname?action=opt_control&command=stop\"><b>$_ctr_actionstop</b></a></td></tr></table>"
		else
		  echo "<table class=\"normtable\"><tr><td bgcolor=\"#ff8080\">$_ctr_statusstop</td><td> <a href=\"$myname?action=opt_control&command=start\"><b>$_ctr_actionstart</b></a> </td></tr></table>"
		fi

		echo "<br><form action=\"$myname\" method=\"get\">"
		echo "<input type=\"hidden\" name=\"action\" value=\"opt_control\">"
		echo "<input type=\"hidden\" name=\"command\" value=\"setbandwidth\">"
		echo "$_ctr_upload:$_ctr_download (kb/s): <input name=\"bandwidth\" size=6 value=\"$PFTPD_BANDWIDTH\">"
		echo "<input type=\"submit\" value=\"$_ctr_change\">"
		echo "</form>"
	fi
	
	if [ "$FORM_command" = "stop" ]
	then
		echo "<p>$_ctr_stopping</p>"
		kill `cat /var/run/pure-ftpd.pid`
		
		echo "<p><form action=\"$myname\" method=\"get\">"
		echo "<input type=\"hidden\" name=\"action\" value=\"opt_control\">"
		echo "<input type=\"submit\" value=\"$_ctr_back\">"
		echo "</form>"
	fi
	
	if [ "$FORM_command" = "start" ]
	then
		echo "<p>$_ctr_starting</p>"
		if [ -f /var/run/pure-ftpd.pid ]
		then
			kill `cat /var/run/pure-ftpd.pid`
		fi
		. /boot/rc.cfg
		. /var/run/pftpd.conf
		. /etc/rc.d/rc400.pftpd >/dev/null 2>/dev/null
 	
		echo "<p><form action=\"$myname\" method=\"get\">"
		echo "<input type=\"hidden\" name=\"action\" value=\"opt_control\">"
		echo "<input type=\"submit\" value=\"$_ctr_back\">"
		echo "</form>"
	fi

	if [ "$FORM_command" = "setbandwidth" ]
	then
		echo "<p>$_ctr_bandwidthupdate</p>"
		FORM_bandwidth=`echo "$FORM_bandwidth" | sed "s/%3A/\:/g"`
		
		if [ -f /var/run/pure-ftpd.pid ]
		then
			kill `cat /var/run/pure-ftpd.pid`
		fi
		. /boot/rc.cfg
		PFTPD_BANDWIDTH=$FORM_bandwidth
		. /etc/rc.d/rc400.pftpd >/dev/null 2>/dev/null
		
		grep -v PFTPD_BANDWIDTH < /var/run/pftpd.conf > /var/run/pftpd.conf1
		mv /var/run/pftpd.conf1 /var/run/pftpd.conf
				
		echo "PFTPD_BANDWIDTH='$FORM_bandwidth'" >> /var/run/pftpd.conf

		echo "<p><form action=\"$myname\" method=\"get\">"
		echo "<input type=\"hidden\" name=\"action\" value=\"opt_control\">"
		echo "<input type=\"submit\" value=\"$_ctr_back\">"
		echo "</form>"
	fi
	;;

opt_user)
	if [ "$FORM_command" = "" ]
	then
		show_tab_header "$_ctr_headeredituser" no
		echo "<form action=\"$myname\" method=\"post\">"
		echo "<input type=\"hidden\" name=\"action\" value=\"opt_user\">"
		echo "<input type=\"hidden\" name=\"command\" value=\"edituser\">"
		echo "<table border=\"0\" cellspacing=\"0\" cellpadding=\"2\">"
		echo "<tr><td>$_ctr_login: </td><td><input name=\"name\" size=\"20\" maxlength=\"64\"></td></tr>"
		echo "<tr><td>$_ctr_password: </td><td><input type=\"password\" name=\"pass1\" size=\"20\" maxlength=\"32\"></td></tr>"
		echo "<tr><td>$_ctr_password_repeat: </td><td><input type=\"password\" name=\"pass2\" size=\"20\" maxlength=\"32\"></td></tr>"
		echo "<tr><td><input type=\"radio\" name=\"mode\" value=\"add\" checked>$_ctr_adduser</td><td></td></tr>"
		echo "<tr><td><input type=\"radio\" name=\"mode\" value=\"modify\">$_ctr_changepassword</td><td></td></tr>"
		echo "<tr><td>$_ctr_localdir: $FTPDIR/</td><td><input name=\"directory\" size=\"20\" maxlength=\"32\"></td></tr>"
		echo "<tr><td></td><td><input type=\"checkbox\" name=\"createdir\" value=\"yes\">$_ctr_createdir</td></tr>"
		echo "<tr><td><input type=submit value=\"$_ctr_ok\"></td><td></td></tr>"
		echo "</table></form>"
		show_tab_footer
		
		show_tab_header "$_ctr_headerdeleteuser" no
		cat "$PWF" | sed "s/:/ /g" > /tmp/pftpd_users
		echo "<table class=\"normtable\">"
		x=1
		while read i n
		do
			echo "<tr><td>$i</td>"
			echo "<td><form action=\"$myname\" method=\"post\">"
			echo "<input type=\"hidden\" name=\"action\" value=\"opt_user\">"
			echo "<input type=\"hidden\" name=\"command\" value=\"deleteuser\">"
			echo "<input type=\"hidden\" name=\"name\" value=\"$i\">"
			echo "<input type=\"hidden\" name=\"number\" value=\"$x\">"
			echo "<input type=\"submit\" value=\"$_ctr_delete\"></form></td></tr>"
			x=`expr $x + 1`
		done </tmp/pftpd_users
		rm /tmp/pftpd_users
		echo "</table>"
		show_tab_footer
	fi

	if [ "$FORM_command" = "edituser" ]
	then
		if [ "$FORM_mode" = "add" ]
		then
			if [ "$FORM_pass1" = "$FORM_pass2" -a "x$FORM_pass1" != "x" ]
			then
				if [ "$FORM_createdir" = "yes" ]
				then
					mkdir $FTPDIR/$FORM_directory
					chown ftpuser.ftpgroup $FTPDIR/$FORM_directory
				fi
				if [ -d "$FTPDIR/$FORM_directory" ]
				then
					echo "<p>$_ctr_creating <b>$FORM_name</b>..."
					(echo $FORM_pass1; echo $FORM_pass1) | pure-pw useradd $FORM_name -u ftpuser -d $FTPDIR/$FORM_directory -f $PWF 2>/dev/null >/dev/null
				else
					echo "<p><b>$_ctr_errordir $FTPDIR/$FORM_directory!</b>"
				fi
			else
				echo "<p><b>$_ctr_errorpass</b>"
			fi
		else
			if [ "$FORM_pass1" = "$FORM_pass2" -a "x$FORM_pass1" != "x" ]
			then
				echo "<p>$_ctr_passchanged <b>$FORM_name</b>..."
				(echo $FORM_pass1; echo $FORM_pass1) | pure-pw passwd $FORM_name -f $PWF 2>/dev/null >/dev/null
			else
				echo "<p><b>$_ctr_errorpass</b>"
			fi
		fi
		
		echo "<p><form action=\"$myname\" method=\"get\">"
		echo "<input type=\"hidden\" name=\"action\" value=\"opt_user\">"
		echo "<input type=\"submit\" value=\"$_ctr_back\">"
		echo "</form>"

		pure-pw mkdb /etc/pureftpd.pdb -f $PWF
	fi
	
	if [ "$FORM_command" = "deleteuser" ]
	then
		echo "<p>$_ctr_userdelete <b>$FORM_name</b>...</p>"
		sed ""$FORM_number"d" "$PWF" > /tmp/pftpd_passwd
		cp /tmp/pftpd_passwd "$PWF"
		rm /tmp/pftpd_passwd
		
		echo "<p><form action=\"$myname\" method=\"get\">"
		echo "<input type=\"hidden\" name=\"action\" value=\"opt_user\">"
		echo "<input type=\"submit\" value=\"$_ctr_back\">"
		echo "</form>"

		pure-pw mkdb /etc/pureftpd.pdb -f $PWF
	fi
	;;

opt_connections)
	if [ "$FORM_command" = "" ]
	then
		echo "<p><form action=\"$myname\" method=\"get\">"
		echo "<input type=\"hidden\" name=\"action\" value=\"opt_connections\">"
		echo "<input type=\"submit\" value=\"$_con_refresh\">"
		echo "</form>"
		
		/usr/local/sbin/pure-ftpwho -s > /tmp/pftpd_info
		
		mv /tmp/pftpd_info /tmp/pftpd_info.1
		x=0
		IFS="\|"
		while read pid acct time state file peer local port current total percentage bandwidth
		do
			if [ $x = 0 ]
			then
				x=1
				echo "<table class=\"normtable\">"
				echo "<tr><th>$_con_action</th><th>PID</th><th>$_con_account</th><th>$_con_time</th><th>$_con_state</th><th>$_con_speed</th><th>$_con_filename</th><th>$_con_remote</th><th>$_con_currentkb</th><th>$_con_totalkb</th><th>$_con_localhost</th></tr>"
			fi

			if [ "$state" = "IDLE" ]
			then
				file="-"
				percentage="&nbsp;"
				echo "<tr valign=\"middle\" align=\"right\"><td><a href=\"$myname?action=opt_connections&command=kill&pid=$pid\"><b>$_con_kill</b></a></td><td>$pid</td><td>$acct</td><td>$time</td><td>$state $percentage</td><td>$bandwidth k/s</td><td>$file</td><td>$peer</td><td>$current</td><td>$total</td><td>$local:$port</td></tr>"
				else
				echo "<tr valign=\"middle\" align=\"right\"><td><a href=\"$myname?action=opt_connections&command=kill&pid=$pid\"><b>$_con_kill</b></a></td><td>$pid</td><td>$acct</td><td>$time</td><td>$state $percentage%</td><td>$bandwidth k/s</td><td>$file</td><td>$peer</td><td>$current</td><td>$total</td><td>$local:$port</td></tr>"
			fi
		done < /tmp/pftpd_info.1
		rm /tmp/pftpd_info.1
		
		if [ $x = 1 ]
		then
			echo "</table>"
		else
			echo "<p>$_con_noconnections"
		fi
	fi
	
	if [ "$FORM_command" = "kill" ]
	then
		echo "<p>$_con_killing $FORM_pid..."
		kill $FORM_pid
		
		echo "<p><form action=\"$myname\" method=\"get\">"
		echo "<input type=\"hidden\" name=\"action\" value=\"opt_connections\">"
		echo "<input type=\"submit\" value=\"$_ctr_back\">"
		echo "</form>"
	fi
	;;	

opt_logfile)
	case $PFTPD_LOG_FORMAT in
		stats)
			cat <<-EOF
<form action="$myname" method="GET">
<input type="hidden" name="action" value="opt_logfile">
<input class="itext" type="text" size="3" maxlength="4" name="log_lines" value="$FORM_log_lines">&nbsp;$_log_lines&nbsp;&nbsp;
<input class="sbutton" type="submit" value="$_log_show">
<input class="sbutton" type="submit" name="showall" value="$_log_show_all">
<!-- <input class="sbutton" type="submit" name="download" value="$_log_download"> -->
<input class="sbutton" type="submit" name="clearlog" value="$_log_clear">
<input type="hidden" name="log_sort" value="$FORM_log_sort">
</form>
EOF
		;;
	esac

	if [ "$FORM_clearlog" != "" ]
	then
		if [ -f "$PFTPD_LOG_PATH" ]
		then
			rm $PFTPD_LOG_PATH
		fi
	fi
	
	if [ -f "$PFTPD_LOG_PATH" ]
	then
		echo "<table class=\"normtable\">"
		sed '1!G;h;$!d' "$PFTPD_LOG_PATH" > /tmp/pftp_log

	n=$FORM_log_lines
	
		case $PFTPD_LOG_FORMAT in
		stats)
			/usr/local/bin/pure-statsdecode /tmp/pftp_log > /tmp/pftp_log.1
			
			case "$FORM_showall" in
				"")
					case $FORM_log_sort in 
						normal)
							cat /tmp/pftp_log.1 | sed -e :a -e '$q;N;'`expr $n + 1`',$D;ba' | sed '1!G;h;$!d' > /tmp/pftp_log.2
						;;
						*)
							cat /tmp/pftp_log.1 | sed '1!G;h;$!d' | sed -e :a -e '$q;N;'`expr $n + 1`',$D;ba' | sed '1!G;h;$!d' > /tmp/pftp_log.2
						;;
					esac
				;;
				*)
					case $FORM_log_sort in 
						normal)
							cat /tmp/pftp_log.1 | sed '1!G;h;$!d' > /tmp/pftp_log.2
						;;
						*)
							cat /tmp/pftp_log.1 > /tmp/pftp_log.2
						;;
					esac
				;;
			esac
			
			echo "<tr><th>"
			case $FORM_log_sort in
				normal)
					echo "<a href=\"$myname?action=opt_logfile&log_lines=$FORM_log_lines&showall=$FORM_showall&log_sort=reverse\">$_log_date<img src="/img/sreverse.gif"></a>"
				;;
				*)
					echo "<a href=\"$myname?action=opt_logfile&log_lines=$FORM_log_lines&showall=$FORM_showall&log_sort=normal\">$_log_date<img src="/img/snormal.gif"></a>"
				;;
			esac
			echo "</th><th>$_log_time</th><th>$_log_sessionid</th><th>$_log_account</th><th>$_log_ip</th><th>$_log_du</th><th>$_log_size</th><th>$_log_time</th><th>$_log_file</th></tr>"
			while read date time1 session account ip state size time file
			do
				echo "<tr valign=\"middle\" align=\"right\"><td>$date</td><td>$time1</td><td>$session</td><td align=\"left\">$account</td><td>$ip</td><td align=\"center\">$state</td><td>$size</td><td>$time</td><td align=\"left\">$file</td></tr>"
			done < /tmp/pftp_log.2
			
			rm /tmp/pftp_log.1
			rm /tmp/pftp_log.2
			;;
	  
		w3c)
			echo "<tr><th>$_log_date</th><th>$_log_time</th><th>$_log_account</th><th>$_log_ip</th><th>$_log_du</th><th>$_log_size</th><th>$_log_file</th></tr>"
			while read date time1 ip state file x account size
			do
				echo "<tr valign=\"middle\" align=\"right\"><td>$date</td><td>$time1</td><td>$account</td><td>$ip</td><td>$state</td><td>$size</td><td>$file</td></tr>"
			done < /tmp/pftp_log
			;;
	  
		clf)
			echo "<tr><th>$_log_date</th><th>$_log_account</th><th>$_log_ip</th><th>$_log_du</th><th>$_log_size</th><th>$_log_file</th></tr>"
			while read ip x account date  c state file y size
			do
				echo "<tr valign=\"middle\" align=\"right\"><td>$date</td><td>$account</td><td>$ip</td><td>$state</td><td>$size</td><td>$file</td></tr>"
			done < /tmp/pftp_log
			;;
		esac
	  
		rm /tmp/pftp_log
		echo "</table>"
	else
		echo "<p>$_log_empty"
	fi
	;;
esac

show_tab_footer
show_html_footer
