. $config
. kernel/kernel-version
askyes "bootsystem" "Make system bootable using bootfloppy/isolinux"

syslinuximg=$archive/syslinux.img
bootfloppyimg=$newisodir/KNOPPIX/boot.img
bootfloppymnt=/tmp/bootfloppy
initrdmnt=/tmp/initrd
isolinuxdir=$newtree/isolinux

if [ $isolinux == 1 ]; then
 pushd $newtree
   mv boot isolinux
   ln -s isolinux boot
 popd
 miniroot=$newtree/boot/miniroot
else
 miniroot=/tmp/miniroot
fi

scsimodules=`cat bootsystem/scsimodules`

umount $bootfloppymnt || true
rm -rf $bootfloppymnt || true
mkdir  $bootfloppymnt
rm -rf $initrdmnt || true
mkdir  $initrdmnt

rm $miniroot || true

if [ $isolinux == 1 ]; then
 cp bootsystem/bootfloppy/syslinux.cfg $isolinuxdir/isolinux.cfg
 cat >> $isolinuxdir/isolinux.cfg < bootsystem/isolinux.cfg-append
 cp bootsystem/bootfloppy/{boot.msg,f2,german.kbd,logo.16} $isolinuxdir/
 cp bootsystem/isolinux/* $isolinuxdir/
 # root device must NOT be /dev/ram0 or linuxrc won't work
 # the real root device gets set in linuxrc, so hda is just a dummy
 rdev $isolinuxdir/vmlinuz /dev/hda
else
 cp $syslinuximg $bootfloppyimg
 # dd if=/dev/zero of=$bootfloppyimg count=1440 bs=1k
 losetup -d /dev/loop0 || true
 losetup /dev/loop0 $bootfloppyimg
 # mkdosfs /dev/loop0
 # sync
 # syslinux -s $bootfloppyimg
 # sync
 mount -t vfat /dev/loop0 $bootfloppymnt
 cp bootsystem/bootfloppy/* $bootfloppymnt/
 cp $newtree/boot/vmlinuz-$VERSION$REV $bootfloppymnt/vmlinuz
 # root device must NOT be /dev/ram0 or linuxrc won't work
 # the real root device gets set in linuxrc, so hda is just a dummy
 rdev $bootfloppymnt/vmlinuz /dev/hda
fi

dd if=/dev/zero of=$miniroot count=1 bs=4096k
losetup -d /dev/loop1 || true
losetup /dev/loop1 $miniroot
mke2fs -b 1024 -N 8192 -q -F -m 0 /dev/loop1
mount /dev/loop1 $initrdmnt

rm bootsystem/miniroot.d/modules/scsi/* || true
cp -a bootsystem/miniroot.d/* $initrdmnt/
cp $newtree/lib/modules/$VERSION$REV/kernel/drivers/block/cloop.o $initrdmnt/modules/
for m in $scsimodules; do
  echo $m
  cp $newtree/lib/modules/$VERSION$REV/kernel/drivers/scsi/$m $initrdmnt/modules/scsi/
done

patch -p0 $initrdmnt/linuxrc < bootsystem/linuxrc.diff

umount $initrdmnt
losetup -d /dev/loop1

if [ $isolinux == 1 ]; then
 gzip -9 $miniroot
else
 gzip -9 -c $miniroot >$bootfloppymnt/miniroot.gz
 umount $bootfloppymnt
 losetup -d /dev/loop0
fi
